<?php

/**
 * Class that operate on table 'rentproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:05
 */
class RentproductMySqlDAO implements RentproductDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RentproductMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM rentproduct WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM rentproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM rentproduct ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param rentproduct primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM rentproduct WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RentproductMySql rentproduct
     */
    public function insert($rentproduct) {
        $sql = 'INSERT INTO rentproduct (name, quantity, buyprice, totalprice, rentprice, paytype, supplierid, createdate, info, isdel,dailyentryid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ? , ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rentproduct->name);
        $sqlQuery->setNumber($rentproduct->quantity);
        $sqlQuery->set($rentproduct->buyprice);
        $sqlQuery->set($rentproduct->totalprice);
        $sqlQuery->set($rentproduct->rentprice);
        $sqlQuery->set($rentproduct->paytype);
        $sqlQuery->setNumber($rentproduct->supplierid);
        $sqlQuery->set($rentproduct->createdate);
        $sqlQuery->set($rentproduct->info);
        $sqlQuery->set($rentproduct->isdel);
        $sqlQuery->setNumber($rentproduct->dailyentryid);



        $id = $this->executeInsert($sqlQuery);
        $rentproduct->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RentproductMySql rentproduct
     */
    public function update($rentproduct) {
        $sql = 'UPDATE rentproduct SET name = ?, quantity = ?, buyprice = ?, totalprice = ?, rentprice = ?, paytype = ?, supplierid = ?, createdate = ?, info = ?, isdel = ? , dailyentryid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rentproduct->name);
        $sqlQuery->setNumber($rentproduct->quantity);
        $sqlQuery->set($rentproduct->buyprice);
        $sqlQuery->set($rentproduct->totalprice);
        $sqlQuery->set($rentproduct->rentprice);
        $sqlQuery->set($rentproduct->paytype);
        $sqlQuery->setNumber($rentproduct->supplierid);
        $sqlQuery->set($rentproduct->createdate);
        $sqlQuery->set($rentproduct->info);
        $sqlQuery->set($rentproduct->isdel);
        $sqlQuery->setNumber($rentproduct->dailyentryid);

        $sqlQuery->setNumber($rentproduct->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM rentproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM rentproduct WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM rentproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM rentproduct WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalprice($value) {
        $sql = 'SELECT * FROM rentproduct WHERE totalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRentprice($value) {
        $sql = 'SELECT * FROM rentproduct WHERE rentprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPaytype($value) {
        $sql = 'SELECT * FROM rentproduct WHERE paytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierid($value) {
        $sql = 'SELECT * FROM rentproduct WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCreatedate($value) {
        $sql = 'SELECT * FROM rentproduct WHERE createdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM rentproduct WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM rentproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM rentproduct WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalprice($value) {
        $sql = 'DELETE FROM rentproduct WHERE totalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRentprice($value) {
        $sql = 'DELETE FROM rentproduct WHERE rentprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPaytype($value) {
        $sql = 'DELETE FROM rentproduct WHERE paytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierid($value) {
        $sql = 'DELETE FROM rentproduct WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCreatedate($value) {
        $sql = 'DELETE FROM rentproduct WHERE createdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RentproductMySql
     */
    protected function readRow($row) {
        $rentproduct = new Rentproduct();

        $rentproduct->id = isset($row['id']) ? $row['id'] : '';
        $rentproduct->name = isset($row['name']) ? $row['name'] : '';
        $rentproduct->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $rentproduct->buyprice = isset($row['buyprice']) ? $row['buyprice'] : '';
        $rentproduct->totalprice = isset($row['totalprice']) ? $row['totalprice'] : '';
        $rentproduct->rentprice = isset($row['rentprice']) ? $row['rentprice'] : '';
        $rentproduct->paytype = isset($row['paytype']) ? $row['paytype'] : '';
        $rentproduct->supplierid = isset($row['supplierid']) ? $row['supplierid'] : '';
        $rentproduct->createdate = isset($row['createdate']) ? $row['createdate'] : '';
        $rentproduct->info = isset($row['info']) ? $row['info'] : '';
        $rentproduct->isdel = isset($row['isdel']) ? $row['isdel'] : '';
        $rentproduct->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';

        return $rentproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RentproductMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>